<?php

namespace App\Classes;

use Carbon\Carbon;

final class TimeUtils
{
    public static function from24to12($hour)
    {

        $hh = intval(substr($hour, 0, 2));

        $AmOrPm = $hh >= 12 ? 'pm' : 'am';

        $hh = $hh >= 12 ? $hh % 12 : $hh;

        $m = substr($hour, 3, 2);

        $finalTime = "$hh:$m $AmOrPm";

        return $finalTime;

    }

    public static function standartDateTimeFormat(string $date)
    {
        return Carbon::createFromFormat('Y-m-d H:i:s', $date)->subHours(4)->format('d-m-Y H:i:s');
    }
}
