<?php

namespace App\Http\Controllers;

use App\Models\Cliente;
use App\Models\Cobranza;
use App\Models\Remota;
use Carbon\Carbon;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    protected $startOfMonth;
    protected $endOfMonth;

    public function __construct()
    {
        $this->startOfMonth = Carbon::now()->format('Y-m-01');
        $this->endOfMonth = Carbon::now()->format('Y-m-t');
    }
    public function index()
    {
        // dd(Remota::where('status', 'inactivo')->count());

        // Calcular rendimiento real
        $rendimiento = Cobranza::calcularRendimientoActual();

        $datos = [
            //== Remotas
            'remotasActivas'            => Remota::where('status', 'activo')->count(),
            'remotasPausadas'           => Remota::where('status', 'pausada')->count(),
            'remotasInactivas'          => Remota::where('status', 'inactivo')->count(),
            'remotasPausadasPorPago'    => Remota::where('status', 'pausada_por_pago')->count(),
            'remotasTotal'              => Remota::count(),
            //=================== Cuentas
            //=====Mes actual
            'saldo_cobrado'             => Cobranza::saldoCobradoRemotasActivasMesActual(),
            'saldo_por_cobrar'          => Cobranza::saldoPorCobrar(),
            'numero_cobros_pendientes'  => Cobranza::cuentasPorCobrar(),
            'total_cobranzas'           => Cobranza::totalCobranzas(),
            //=====Rendimiento
            'rendimiento'               => $rendimiento['rendimiento'],
            'total_actual'              => $rendimiento['total_actual'],
            'total_anterior'            => $rendimiento['total_anterior'],
            //=====Tabla
            'clientes'                    =>     Cliente::with('remotas')->get(),
        ];
        return view('dashboard', compact('datos'));
    }


    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
