<?php

namespace App\Http\Controllers;

use App\Enums\TipoClientes;
use App\Models\Cliente;
use App\Models\Cobranza;
use App\Models\ModeloMikrotik;
use App\Models\PaymentMethod;
use App\Models\Plan;
use App\Models\Proveedor;
use App\Models\Remota;
use App\Models\Socio;
use App\Models\TicketPlus\PcValidacion;
use App\Models\Vendedor;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;

class RemotasController extends Controller
{
    public function create()
    {

        $clientes = Cliente::all();

        $planes = Plan::all();

        $socios = Socio::with('persona')->get(['persona_id']);

        $vendedores = Vendedor::with('persona')->get();

        $proveedores = Proveedor::with('empresa')->get();

        $TipoClientes = TipoClientes::class;

        $ModelosMicrotik = ModeloMikrotik::all();

        $remota = new Remota();

        $payment_methods = PaymentMethod::where('tipo_metodo_pago', 'empresa')->get();

        // Licencias de TicketPlus para el select en el formulario
        $licencias_Ticketplus = PcValidacion::obtenerClientesDetallado();

        $data = [
            'clientes' => $clientes,
            'TipoClientes' => TipoClientes::class,
            'planes' => $planes,
            'socios' => $socios,
            'vendedores' => $vendedores,
            'proveedores' => $proveedores,
            'statuses' => ['activo' => 'Activo', 'inactivo' => 'Inactivo', 'pausada' => 'Pausada', 'pausada_por_pago' => 'Pausada por pago']

        ];
        return view('remotas.create-form', compact('data', 'clientes', 'planes', 'socios', 'vendedores', 'proveedores', 'TipoClientes', 'ModelosMicrotik', 'payment_methods', 'remota', 'licencias_Ticketplus'));
    }
    public function store(Request $request)
    {
        // dd($request->all());
        try {
            $validatedData = $request->validate([
                'nombre_equipo'          => 'required',
                'tipo_router_id'         => 'required',
                'puerto'                 => 'required',
                'ip_gestion'             => 'required',
                'ubicacion'              => 'required',
                'detalle'                => 'required',
                // 'zona'                   => 'required',
                // 'encargado'              => 'required',
                // 'serial'                 => 'required',
                'kit_serial'             => 'required',
                // 'antena_serial'          => 'required',
                'dia_corte'              => 'required',
                'dia_activacion'         => 'required',
                'paymenth_method_id'          => 'required',
                // 'correo_cuenta'          => 'required',
                // 'password_correo_cuenta' => 'required',
                // 'fecha_cuenta' => 'required',
                'cliente_id'             => 'required',
                'proveedor_id'           => 'required',
                // 'socio_id'               => 'required',
                'vendedor_id'            => 'required',
                'comision_vendedor'      => 'required',
                'plan_id'                => 'required',
                'costo_plan'             => 'required',
                'status'                 => 'required',
                // 'uuid' => 'required',
                // 'meses_contrato'         => 'required',
            ]);

            $Remota = Remota::create([
                'equipo' => $request->nombre_equipo,
                'tipo_router_id' => $request->tipo_router_id,
                'puerto' => $request->puerto,
                'ip_gestion' => $request->ip_gestion,
                'ubicacion' => $request->ubicacion,
                'detalle' => $request->detalle,
                'zona' => $request->zona,
                'encargado' => $request->encargado,
                'serial' => $request->serial ?? null,
                'kit_serial' => $request->kit_serial,
                'antena_serial' => $request->antena_serial ?? null,
                'dia_corte' => $request->dia_corte ?? Carbon::createFromFormat('d/m/Y', $request->dia_corte),
                'dia_activacion' =>  $request->dia_activacion ?? Carbon::createFromFormat('d/m/Y', $request->dia_activacion),
                'metodo_de_pago_id' => $request->paymenth_method_id ?? 1,
                'correo_cuenta' => $request->correo_cuenta ?? null,
                'password_correo_cuenta' => $request->password_correo_cuenta ?? null,
                'fecha_cuenta' => $request->fecha_cuenta == null ? null : $request->fecha_cuenta,
                'cliente_id' => $request->cliente_id,
                'proveedor_id' => $request->proveedor_id,
                'socio_id' => $request->socio_id,
                // 'vendedor_id' => 1,
                'vendedor_id' => (int)$request->vendedor_id,
                'comision' => $request->comision_vendedor,
                'plan_id' => $request->plan_id,
                'costo' => $request->costo_plan,
                'status' =>  $request->status,
                'meses_contrato' => $request->meses_contrato ?? 0,
                // 'uuid' => $request->uuid,
                'detalles_extra' => $request->detalles_extra ?? null,
            ]);

            $Cobro = Cobranza::create([
                'cliente_id' => $request->cliente_id,
                'concepto' => 'Pago de mensualidad',
                'remota_id' => $Remota->id,
                'monto' => $request->costo_plan,
                'fecha' => $request->dia_corte ?? Carbon::createFromFormat('d/m/Y', $request->dia_corte),
            ]);


            return redirect()->route('remotas.index')->with(
                [
                    'type' => 'success',
                    'message' => 'Remota ( ' . $Remota->id . ' ) creada correctamente'
                ]
            );
        } catch (ValidationException $e) {
            return back()->withErrors($e->errors())->withInput();
        }
    }
    public function show($id)
    {
        $remota = Remota::where('id', $id)->firstOrFail();

        $clientes = Cliente::all();

        $planes = Plan::where('proveedor_id', $remota->proveedor_id)->get();

        $socios = Socio::with('persona')->get(['persona_id']);

        $vendedores = Vendedor::with('persona')->get();

        $proveedores = Proveedor::with('empresa')->get();

        $TipoClientes = TipoClientes::class;

        $ModelosMicrotik = ModeloMikrotik::all();

        $payment_methods = PaymentMethod::where('tipo_metodo_pago', 'empresa')->get();

        // Licencias de TicketPlus para el select en el formulario de solo lectura
        $licencias_Ticketplus = PcValidacion::obtenerClientesDetallado();

        $data = [
            'clientes' => Cliente::all(),
            'TipoClientes' => TipoClientes::class,
            'planes' =>  Plan::all(),
            'socios' => Socio::with('persona')->get(['persona_id']),
            'vendedores' => Vendedor::with('persona')->get(),
            'proveedores' => Proveedor::with('empresa')->get(),
            'ModelosMicrotik' => ModeloMikrotik::all(),
            'statuses' => ['activo' => 'Activo', 'inactivo' => 'Inactivo', 'pausada' => 'Pausada', 'pausada_por_pago' => 'Pausada por pago']
        ];
        return view('remotas.show-form', compact('data', 'remota', 'clientes', 'planes', 'socios', 'vendedores', 'proveedores', 'TipoClientes', 'ModelosMicrotik', 'payment_methods', 'licencias_Ticketplus'));
    }
    public function edit($uuid)
    {
        $remota = Remota::where('uuid', $uuid)->firstOrFail();

        $clientes = Cliente::all();

        $planes = Plan::where('proveedor_id', $remota->proveedor_id)->get();

        $socios = Socio::with('persona')->get(['persona_id']);

        $vendedores = Vendedor::with('persona')->get();

        $proveedores = Proveedor::with('empresa')->get();

        $TipoClientes = TipoClientes::class;

        $ModelosMicrotik = ModeloMikrotik::all();

        $payment_methods = PaymentMethod::where('tipo_metodo_pago', 'empresa')->get();

        $licencias_Ticketplus = PcValidacion::obtenerClientesDetallado();

        $data = [
            'clientes' => Cliente::all(),
            'TipoClientes' => TipoClientes::class,
            'planes' =>  Plan::all(),
            'socios' => Socio::with('persona')->get(['persona_id']),
            'vendedores' => Vendedor::with('persona')->get(),
            'proveedores' => Proveedor::with('empresa')->get(),
            'ModelosMicrotik' => ModeloMikrotik::all(),
            'statuses' => ['activo' => 'Activo', 'inactivo' => 'Inactivo', 'pausada' => 'Pausada', 'pausada_por_pago' => 'Pausada por pago']
        ];
        return view('remotas.edit-form', compact('data', 'remota', 'clientes', 'planes', 'socios', 'vendedores', 'proveedores', 'TipoClientes', 'ModelosMicrotik', 'payment_methods', 'licencias_Ticketplus'));
    }
    public function update(Request $request, $id)
    {
        $remota = Remota::where('id', $request->id)->first();
        $cobro = Cobranza::where('remota_id', $id)->where('concepto', '=', 'Pago de mensualidad')
            ->where('status', '=', 'pendiente')
            ->first();

        try {
            $validatedData = $request->validate([
                'nombre_equipo'          => 'required',
                'tipo_router_id'         => 'required',
                'puerto'                 => 'required',
                'ip_gestion'             => 'required',
                'ubicacion'              => 'required',
                'detalle'                => 'required',
                // 'zona'                   => 'required',
                // 'encargado'              => 'required',
                // 'serial'                 => 'required',
                'kit_serial'             => 'required',
                // 'antena_serial'          => 'required',
                'dia_corte'              => 'required',
                'dia_activacion'         => 'required',
                // 'correo_cuenta'          => 'required',
                // 'password_correo_cuenta' => 'required',
                // 'fecha_cuenta' => 'required',
                'cliente_id'             => 'required',
                'proveedor_id'           => 'required',
                // 'socio_id'               => 'required',
                'vendedor_id'            => 'required',
                'comision_vendedor'      => 'required',
                'plan_id'                => 'required',
                'costo_plan'             => 'required',
                'status'                 => 'required',
                // 'uuid' => 'required',
                // 'meses_contrato'         => 'required',
            ]);
            $remota->equipo = $request->nombre_equipo;
            $remota->tipo_router_id = $request->tipo_router_id;
            $remota->puerto = $request->puerto;
            $remota->ip_gestion = $request->ip_gestion;
            $remota->ubicacion = $request->ubicacion;
            $remota->detalle = $request->detalle;
            $remota->zona = $request->zona;
            $remota->encargado = $request->encargado;
            $remota->serial = $request->serial;
            $remota->kit_serial = $request->kit_serial;
            $remota->antena_serial = $request->antena_serial;
            $remota->metodo_de_pago_id = $request->paymenth_method_id ?? 1;
            $remota->dia_corte =  $request->dia_corte ?? Carbon::createFromFormat('d/m/Y', $request->dia_corte);
            $remota->dia_activacion = $request->dia_activacion ?? Carbon::createFromFormat('d/m/Y', $request->dia_activacion);
            $remota->correo_cuenta = $request->correo_cuenta;
            $remota->password_correo_cuenta = $request->password_correo_cuenta;
            $remota->fecha_cuenta = $request->fecha_cuenta == null ? null : $request->fecha_cuenta ?? Carbon::createFromFormat('d/m/Y', $request->fecha_cuenta);
            $remota->cliente_id = $request->cliente_id;
            $remota->proveedor_id = $request->proveedor_id;
            $remota->socio_id = $request->socio_id;
            // 'vendedor_id' = 1,
            $remota->vendedor_id = (int)$request->vendedor_id;
            $remota->comision = $request->comision_vendedor;
            $remota->plan_id = $request->plan_id;
            $remota->costo = $request->costo_plan;
            $remota->status =  $request->status;
            $remota->meses_contrato = $request->meses_contrato ?? 0;
            $remota->detalles_extra = $request->detalles_extra ?? null;
            $remota->TxtIdentity = $request->TxtIdentity ?? null;


            $cobro->monto = $request->costo_plan;
            $cobro->fecha =  $request->dia_corte ?? Carbon::createFromFormat('d/m/Y', $request->dia_corte);
            $cobro->save();

            // 'uuid' = $request->uuid,

            $remota->save();
            return redirect()->route('remotas.index')->with(
                [
                    'type' => 'info',
                    'message' => 'Remota ( ' . $remota->id . ' ) actualizada correctamente'
                ]
            );
        } catch (ValidationException $e) {
            return back()->withErrors($e->errors())->withInput();
        }
    }


    public function getFechasDeCuentas()
    {
        $events = Remota::select('id', 'equipo as title', 'fecha_cuenta as start', 'fecha_cuenta as end')->get();

        /*
        title: El título del evento.
        start: La fecha y hora de inicio del evento (en formato YYYY-MM-DDTHH:mm:ss).
        end (opcional): La fecha y hora de finalización del evento (en formato YYYY-MM-DDTHH:mm:ss). Si no tienes un evento de duración específica, puedes omitir este campo.
        description (opcional): Descripción del evento.
        location (opcional): Lugar donde se realizará el evento.
        */
        return response()->json($events);
    }
}
