<?php

namespace App\Http\Controllers;

use App\Models\Cliente;
use App\Models\Cobranza;
use App\Models\CobrosHistorial;
use App\Models\Remota;
use App\Models\Vendedor;
use Illuminate\Http\Request;
use Barryvdh\DomPDF\Facade\Pdf;
use Carbon\Carbon;

class ReportesController extends Controller
{
    public function vendedores_index()
    {
        // if (session()->has('message')) $this->alert(session('type'), session('message'));
        $vendedores = Vendedor::all();
        // $clientes = Cliente::all();
        // dd($clientes[0]->clientable->nombres);
        $clientes = Cliente::all()->sortBy(function($cliente) {
            return $cliente->getClientName();
        });
        return view('reportes.reporte_vendedores', compact('vendedores', 'clientes'));
    }
    public function vendedores_pdf(Request $request)
    {

        $request->validate([
            'vendedor_id' => 'required|exists:vendedores,id',
        ]);
        // dd($request->all());
        $fecha_desde = $request->fecha_desde == null ? now()->addDays(-30)->format('Y-m-d') : (Carbon::createFromFormat('d/m/Y', $request->fecha_desde))->format('Y-m-d');
        // dd($fecha_desde);
        $fecha_hasta = $request->fecha_hasta == null ? now()->addDays(30)->format('Y-m-d') : (Carbon::createFromFormat('d/m/Y', $request->fecha_hasta))->format('Y-m-d');
        $fechas = [
            'fecha_desde' => $request->fecha_desde,
            'fecha_hasta' => $request->fecha_hasta,
            'fecha_generacion' => now()->format('d/m/Y H:i:s')
        ];
        $status = $request->status_remota;
        $vendedorId = $request->vendedor_id;

        $cobros = CobrosHistorial::with('paymentMethod')
            ->whereBetween('fecha_pago', [$fecha_desde, $fecha_hasta])
            ->whereHas('remota.vendedor', function ($query) use ($vendedorId) {
                $query->where('vendedor_id', $vendedorId);
            })
            ->when($status !== 'todas', function ($query) use ($status) {
                // Only filter by status if status is not 'todas'
                $query->whereHas('remota', function ($q) use ($status) {
                    $q->where('status', $status);
                });
            })
            ->whereHas('cobro', function ($query) {
                $query->where('status', 'pagado');
            })
            ->get();

        // dd($cobros);
        if ($cobros->isEmpty()) {
            return redirect()->back()->with([
                'type' => 'error',
                'message' => 'No se encontraron cobros para el vendedor en el período seleccionado.'
            ]);
        }
        $vendedor = $cobros[0]->vendedor;

        $logo = '/light-bootstrap/img/logo.png';
        $pdf = Pdf::loadView('reportes.pdf.reporte_vendedores', compact('vendedor', 'cobros', 'fechas', 'logo'));

        $formato_desde = (Carbon::createFromFormat('d/m/Y', $request->fecha_desde))->format('d-m-y');
        $formato_hasta = (Carbon::createFromFormat('d/m/Y', $request->fecha_hasta))->format('d-m-y');
        $formato =   $cobros[0]->vendedor . ' (' . $formato_desde . ' - ' . $formato_hasta . ')';
        // return $pdf->stream();
        return $pdf->download('Reporte de ventas ' .  $formato . '.pdf');
    }

    public function cobranzas_pdf(Request $request)
    {


        // dd($request->all());
        $fecha_desde = $request->fecha_desde == null ? now()->addDays(-30)->format('Y-m-d') : (Carbon::createFromFormat('d/m/Y', $request->fecha_desde))->format('Y-m-d');
        // dd($fecha_desde);
        $fecha_hasta = $request->fecha_hasta == null ? now()->addDays(30)->format('Y-m-d') : (Carbon::createFromFormat('d/m/Y', $request->fecha_hasta))->format('Y-m-d');
        $fechas = [
            'fecha_desde' => $request->fecha_desde,
            'fecha_hasta' => $request->fecha_hasta,
            'fecha_generacion' => now()->format('d/m/Y H:i:s')
        ];
        $status = $request->status_remota;
        $cobros = CobrosHistorial::with('paymentMethod')
            ->whereBetween('fecha_pago', [$fecha_desde, $fecha_hasta])
            ->whereHas('remota', function ($query) use ($status) {
                $query->where('status', $status);
            })
            ->whereHas('cobro', function ($query) {
                $query->where('status', 'pagado');
            })
            ->get();

        $logo = '/light-bootstrap/img/logo.png';
        $pdf = Pdf::loadView('reportes.pdf.reporte_cobranzas', compact('cobros', 'fechas', 'logo'));

        $formato_desde = (Carbon::createFromFormat('d/m/Y', $request->fecha_desde))->format('d-m-y');
        $formato_hasta = (Carbon::createFromFormat('d/m/Y', $request->fecha_hasta))->format('d-m-y');
        $formato =   ' (' . $formato_desde . ' - ' . $formato_hasta . ')';
        return $pdf->download('Reporte de cobranzas ' .  $formato . '.pdf');
    }
    public function gerencial_pdf(Request $request)
    {


        // dd($request->all());
        $fecha_desde = $request->fecha_desde == null ? now()->addDays(-30)->format('Y-m-d') : (Carbon::createFromFormat('d/m/Y', $request->fecha_desde))->format('Y-m-d');
        // dd($fecha_desde);
        $fecha_hasta = $request->fecha_hasta == null ? now()->addDays(30)->format('Y-m-d') : (Carbon::createFromFormat('d/m/Y', $request->fecha_hasta))->format('Y-m-d');
        $fechas = [
            'fecha_desde' => $request->fecha_desde,
            'fecha_hasta' => $request->fecha_hasta,
            'fecha_generacion' => now()->format('d/m/Y H:i:s')
        ];
        $status = $request->status_remota;

        $cobranza = new Cobranza();

        $datos = [
            //== Remotas
            'remotasActivas'            => Remota::where('status', 'activo')->count(),
            'remotasPausadas'           => Remota::where('status', 'pausada')->count(),
            'remotasInactivas'          => Remota::where('status', 'inactivo')->count(),
            'remotasPausadas'    => Remota::where('status', 'pausada')->count(),
            'remotasPausadasPorPago'    => Remota::where('status', 'pausada_por_pago')->count(),
            'remotasTotal'              => Remota::count(),
            //=================== Provedores
            'CloudSatPagos'               => Cobranza::obtenerSumaMontosPagadosPorProveedor($fecha_desde, $fecha_hasta, $proveedorId = 1),
            'RebaurPagos'                 => Cobranza::obtenerSumaMontosPagadosPorProveedor($fecha_desde, $fecha_hasta, $proveedorId = 2),
            //=================== Clientes y pagos
            //=====clientes
            'totalCobranzas'              =>     Cobranza::whereBetween('fecha', [$fecha_desde, $fecha_hasta])->count(),
            'clientes'                    =>     Cliente::with('remotas')->count(),
            'totalDeMensualidades'        =>     Cobranza::totalPagosMensualidad($fecha_desde, $fecha_hasta, $status_cobro = 'pagado'),
            'totalDePagosForaneos'        =>     Cobranza::totalPagosNoMensualidad($fecha_desde, $fecha_hasta),
            'totalCobros'                 =>     Cobranza::whereBetween('fecha', [$fecha_desde, $fecha_hasta])->where('status', $status_cobro = 'pagado')->sum('monto'),
            //=================== Mensualidades
            'totalPagadoMensualidades'     => Cobranza::totalPagadoMensualidades($fecha_desde, $fecha_hasta, $status_cobro = 'pagado'),
            'TotalCostoMensualidades'      => Cobranza::totalCostoMensualidades($fecha_desde, $fecha_hasta),
            'totalComisionesMensualidades' => Cobranza::totalComisionesMensualidades($fecha_desde, $fecha_hasta),
            'totalUtilidadMensualidades'   => Cobranza::totalUtilidadMensualidades($fecha_desde, $fecha_hasta),
            //=================== Métodos de pago recibidos
            'metodosPago'                 => $cobranza->getMontosPorMetodoDePago($fecha_desde, $fecha_hasta),
        ];

        $logo = '/light-bootstrap/img/logo.png';
        $pdf = Pdf::loadView('reportes.pdf.reporte_gerencial', compact('datos', 'fechas', 'logo'));

        $formato_desde = (Carbon::createFromFormat('d/m/Y', $request->fecha_desde))->format('d-m-y');
        $formato_hasta = (Carbon::createFromFormat('d/m/Y', $request->fecha_hasta))->format('d-m-y');
        $formato =   ' (' . $formato_desde . ' - ' . $formato_hasta . ')';
        // return $pdf->stream();
        return $pdf->download('Reporte de gerencial ' .  $formato . '.pdf');
    }

    public function clientes_pdf(Request $request)
    {
        $fecha_desde = $request->fecha_desde == null ? now()->addDays(-30)->format('Y-m-d') : (Carbon::createFromFormat('d/m/Y', $request->fecha_desde))->format('Y-m-d');
        $fecha_hasta = $request->fecha_hasta == null ? now()->addDays(30)->format('Y-m-d') : (Carbon::createFromFormat('d/m/Y', $request->fecha_hasta))->format('Y-m-d');
        $fechas = [
            'fecha_desde' => $request->fecha_desde,
            'fecha_hasta' => $request->fecha_hasta,
            'fecha_generacion' => now()->format('d/m/Y H:i:s')
        ];

        $cliente = Cliente::find($request->cliente_id);
        $cobros = CobrosHistorial::with(['remota.plan', 'paymentMethod'])
            ->where('cliente_id', $request->cliente_id)
            ->whereBetween('fecha_pago', [$fecha_desde, $fecha_hasta])
            ->get();

        $logo = '/light-bootstrap/img/logo.png';

        $pdf = Pdf::loadView('reportes.pdf.reporte_cliente', compact('cliente', 'cobros', 'fechas', 'logo'));
        // return $pdf->stream();
        $formato_desde = (Carbon::createFromFormat('d/m/Y', $request->fecha_desde))->format('d-m-y');
        $formato_hasta = (Carbon::createFromFormat('d/m/Y', $request->fecha_hasta))->format('d-m-y');
        $formato =   ' (' . $formato_desde . ' - ' . $formato_hasta . ')';
        return $pdf->download('Reporte de cliente ' .  $cliente->getClientName() . '.pdf');
        // return $pdf->download('Reporte de cliente ' .  $cliente->getClientName() . '.pdf');
    }
}
