<?php

namespace App\Http\Controllers;

use App\Models\Socio;
use Illuminate\Http\Request;
use RealRashid\SweetAlert\Facades\Alert;

class SociosController extends Controller
{
    //

    public function index()
    {
        // dd('Hola');
        $personas = Socio::all();
        $metadatos = [
            'title' => 'Socios',
            'description' => 'Listado de socios',
            'routes_key' => 'socios',
        ];
        toast('Success Toast', 'success');

        alert()->success('SuccessAlert', 'Lorem ipsum dolor sit amet.');

        return view('persona.index', compact('personas', 'metadatos'));
    }

    public function create()
    {
        $metadatos = [
            'title' => 'Crear Socio',
            'description' => 'Formulario para crear un socio',
            'routes_key' => 'socios',
        ];
        return view('persona.create', compact('metadatos'));
    }

    public function store(Request $request)
    {
        dd($request->all());

        Socio::create($request->all());

        return redirect()->route('socios.index');
    }
}
