<?php

namespace App\Http\Controllers;

use App\Models\Cobranza;
use Illuminate\Http\Request;
use Carbon\Carbon;

class TotalesMensualesController extends Controller
{
    /**
     * Muestra la vista de totales mensuales
     */
    public function index(Request $request)
    {
        $year = $request->get('year', Carbon::now()->year);

        // Validar que el año esté en un rango razonable
        $year = max(2020, min(2030, (int)$year));

        $totalesMensuales = Cobranza::getTotalesMensuales($year);

        // Obtener años disponibles para el selector
        $añosDisponibles = $this->getAñosDisponibles();

        // Si es una petición AJAX, devolver solo el contenido de la tabla
        if ($request->ajax()) {
            return view('totales-mensuales', compact('totalesMensuales', 'year', 'añosDisponibles'))->render();
        }

        return view('totales-mensuales', compact('totalesMensuales', 'year', 'añosDisponibles'));
    }

    /**
     * Obtiene los años disponibles en la base de datos
     */
    private function getAñosDisponibles()
    {
        $años = Cobranza::where('status', 'pagado')
            ->selectRaw('YEAR(fecha) as año')
            ->distinct()
            ->orderBy('año', 'desc')
            ->pluck('año')
            ->toArray();

        // Si no hay datos, incluir al menos el año actual
        if (empty($años)) {
            $años = [Carbon::now()->year];
        }

        return $años;
    }
}
