<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Auth;

class VerificarSesion
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Verificar si el usuario está autenticado
        if (!Auth::check()) {
            // Si no está autenticado, redirigir al login
            return redirect('/drok');
        }

        // Verificar si la sesión ha expirado
        if (session()->has('lastActivity') && (time() - session('lastActivity') > config('session.lifetime') * 60)) {
            Auth::logout(); // Cerrar sesión
            return redirect('/drok')->with('message', 'Tu sesión ha expirado.'); // Redirigir al login con un mensaje
        }

        // Actualizar la última actividad
        session(['lastActivity' => time()]);


        // Si está autenticado, continuar con la solicitud
        return $next($request);
    }
}
