<?php

namespace App\Livewire;

use Rappasoft\LaravelLivewireTables\DataTableComponent;
use Rappasoft\LaravelLivewireTables\Views\Column;
use App\Models\Cliente;
use App\Models\Remota;
use Rappasoft\LaravelLivewireTables\Views\Columns\ArrayColumn;

class ClientesDatatable extends DataTableComponent
{
    protected $model = Remota::class;

    public function configure(): void
    {
        $this->setPrimaryKey('id');
        $this->setDefaultSort('id', 'asc');
    }

    public function columns(): array
    {


        return [
            Column::make("Id", "id")
                ->sortable(),
            // Column::make("Nombre", "clientable_type")
            //     ->sortable()
            //     ->format(fn ($value) => $value == 'App\Models\Empresa' ? 'Empresa' : 'Persona')
            //     ->searchable(),

            Column::make("Serial antena", "antena_serial")
                ->sortable()
                ->searchable(),

            Column::make("Nombre Remota", "equipo")
                ->sortable()
                ->searchable(),
            // Column::make("Updated at", "updated_at")
            //     ->sortable(),
        ];
    }
}
