<?php

namespace App\Livewire\Cobranza;

use App\Classes\LivewireFormsComponent;
use App\Enums\TipoClientes;
use App\Livewire\Forms\CobranzaForm;
use App\Models\Cliente;
use App\Models\Plan;
use App\Models\Proveedor;
use App\Models\Cobranza;
use App\Models\Socio;
use App\Models\Vendedor;
use Carbon\Carbon;
use Exception;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\Computed;
use Livewire\Attributes\Locked;
use Illuminate\Http\Request;

final class CobranzaFormComponent extends LivewireFormsComponent
{
    use LivewireAlert;

    public CobranzaForm $form;

    #[Locked]
    public string $pageTitle = 'Registrar Cobranza';

    #[Locked]
    public ?string $id = null;
    public ?string $uuid = null;


    public function render()
    {
        // if ($this->uuid && empty($this->getErrorBag()->getMessages())) {
        //     $this->fillForm();
        //     $this->pageTitle = 'Editar Cobranza';
        // }

        $clientes = Cliente::all();

        $TipoClientes = TipoClientes::class;





        return view('livewire.cobranza.cobranza-form-component', compact('clientes', 'TipoClientes'));
    }

    public function mount(?string $id = null, ?string $uuid = null)
    {
        $this->id = $id;
        $this->uuid = $uuid;
    }

    #[Computed(persist: true)]
    public function cobranza()
    {
        return Cobranza::where('id', $this->id)->first();
    }

    public function save()
    {

        try {
            $this->form->save($this->cobranza);
            $this->form->reset();
            return redirect()->route('cobros.index')->with(
                [
                    'type' => 'success',
                    'message' => 'Cobranza creada correctamente'
                ]
            );
        } catch (Exception $e) {
            throw_if(env('APP_DEBUG'), $e);
            $this->alert('error', 'Error al registrar la cobranza.', [
                'timer' => 5000,
            ]);
        }
    }

    protected function fillForm()
    {
        $this->form->fill([
            'cliente_id' => $this->cobranza->cliente_id,
            'concepto' => $this->cobranza->concepto,
            'remota_id' => $this->cobranza->remota_id,
            'monto' => $this->cobranza->monto,
            'fecha' => $this->cobranza->fecha,
        ]);
    }
    public function store(Request $request)
    {
        try {
            // Guardar en el modelo cobros con trycatch
        //     $request->validate([
        //         'cliente_id' => 'required',
        //     'concepto' => 'required',
        //     'monto' => 'required|numeric|min:0|max:999999.99',
        // ]);

        $Cobranza = Cobranza::create([
            'cliente_id' => $request->cliente_id,
            'concepto' => $request->concepto,
            // 'remota_id' => $request->remota_id ?? null,
            'monto' => $request->monto,
            'fecha' => Carbon::now(),
        ]);
        return redirect()->route('cobros.index')->with(
            [
                'type' => 'success',
                'message' => 'Cobranza creada correctamente'
            ]
            );
        } catch (Exception $e) {
            throw_if(env('APP_DEBUG'), $e);
            return back()->with(
                [
                    'type' => 'error',
                    'message' => 'Error al registrar la cobranza.',
                ]
            );
        }
    }
}
