<?php

namespace App\Livewire\Cobranza;

use App\Models\Cobranza;
use App\Models\CobrosHistorial;
use App\Models\PaymentMethod;
use App\Models\Remota;
use App\Traits\CobrosMensualidadesTrait;
use Carbon\Carbon;
use Exception;
use Illuminate\Support\Facades\DB;
use Livewire\Component;
use Livewire\WithPagination;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\Url;
use Illuminate\Database\QueryException;

class CobrosMensualidadesComponent extends Component
{
    use LivewireAlert, WithPagination, CobrosMensualidadesTrait;
    public string $title = 'Cobros de mensualidades pendientes ';

    protected $listeners = [
        'listenersPagar' => 'pagar',
        'listenersExonerar' => 'exonerarPagoCobroRemota',
        'listenersEnviarMensaje' => 'enviarMensaje',
    ];

    public function mount()
    {
        $this->redirect = 'cobros_mensualidades.index';
    }

    //===============================================Render
    public function render()
    {
        $remotas_por_pagar =  Cobranza::JoinRemotas($this->search, $this->status_cobros, $this->status_remota, $this->orderBy)
            ->where('cobros.fecha', '<=', now()->addDays(5)->format('Y-m-d'))
            ->get();

            // dd($remotas_por_pagar[0]);

        $payment_methods = PaymentMethod::where('tipo_metodo_pago', 'cliente')->get();


        if (session()->has('message')) $this->alert(session('type'), session('message'));

        return view('livewire.cobranza.cobros-mensualidades-component', compact('remotas_por_pagar', 'payment_methods'));
    }

    public function enviarMensaje($remota = null, $tipo = null)
    {
        try {
            // Si viene como objeto, extraer valores
            if (is_array($remota)) {
                $tipo = $remota['tipo'] ?? $tipo;
                $remota = $remota['remota'] ?? null;
            }

            // Validaciones específicas de entrada
            if (!$remota) {
                $this->alert('error', 'No se recibió el identificador de la remota.');
                return;
            }

            if (!$tipo) {
                $this->alert('error', 'Seleccione el tipo de mensaje a enviar.');
                return;
            }

            if (!in_array($tipo, ['proximo', 'vencido'])) {
                $this->alert('error', 'Tipo de mensaje inválido. Use "proximo" o "vencido".');
                return;
            }

            $remotaModel = Remota::find($remota);
            if (!$remotaModel) {
                $this->alert('error', 'La remota indicada no existe.');
                return;
            }

            if (empty($remotaModel->TxtIdentity)) {
                $this->alert('warning', 'La remota no tiene licencia TicketPlus asociada. Asocie una licencia desde la ficha de la remota.');
                return;
            }

            // Determinar contenido del mensaje según tipo
            $clienteNombre = optional($remotaModel->cliente)->getClientName() ?? 'cliente';
            $equipo = $remotaModel->equipo ?? 'equipo';
            $mensaje = $tipo === 'proximo'
                ? "Estimado(a) {$clienteNombre}, su servicio asociado al equipo \"{$equipo}\" está próximo a vencer."
                : "Estimado(a) {$clienteNombre}, su servicio asociado al equipo \"{$equipo}\" se encuentra vencido.";

            // Guardar notificación en base TicketPlus (mínimos, usando "Notificación web")
            \App\Models\TicketPlus\NotificacionPush::create([
                'TxtIdentity' => $remotaModel->TxtIdentity,
                'Notificacion' => 'Notificación web: ' . $mensaje,
                'TipoNot' => $tipo === 'proximo' ? 'PRO' : 'VEN',
                'DatFecha' => now(),
                'Estado' => 0,
            ]);

            $this->alert('success', 'Mensaje enviado correctamente');
        } catch (QueryException $qe) {
            $this->alert('error', 'No se pudo registrar la notificación en TicketPlus. Verifique la conexión y permisos. Código: ' . $qe->getCode());
        } catch (\Throwable $e) {
            $this->alert('error', 'No se pudo enviar el mensaje. Detalle: ' . $e->getMessage());
        }
    }
}
