<?php

namespace App\Livewire\Cobranza;

use App\Models\Cobranza;
use App\Models\PaymentMethod;
use App\Traits\CobrosMensualidadesTrait;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Component;
use Livewire\WithPagination;

class CobrosMensualidadesFuturasComponent extends Component
{
    use LivewireAlert, WithPagination, CobrosMensualidadesTrait;

    protected $listeners = [
        'listenersPagarFuturo' => 'pagar',
        'listenersExonerarFuturo' => 'exonerarPagoCobroRemota',
    ];

    public string $title = 'Adelantar Cobros de mensualidades ';

    public function mount()
    {
        $this->redirect = 'cobros_mensualidades_futuras.index';
    }



    public function render()
    {

        $remotas_por_pagar =  Cobranza::JoinRemotas($this->search, $this->status_cobros, $this->status_remota, $this->orderBy)
            // ->where('cobros.fecha', '>=', now()->addDays(10)->format('Y-m-d'))
            ->where('cobros.fecha', '>', now()->format('Y-m-d'))
            ->orderBy('cobros.fecha', 'desc')
            // ->paginate($this->perPage);
            ->get();

        $payment_methods = PaymentMethod::where('tipo_metodo_pago', 'cliente')->get();

        if (session()->has('message')) $this->alert(session('type'), session('message'));

        return view('livewire.cobranza.cobros-mensualidades-futuras-component', compact('remotas_por_pagar', 'payment_methods'));
    }
}
