<?php

namespace App\Livewire\Data;

use App\Traits\StaticCreateSelf;
use App\Traits\ToArray;
use Livewire\Wireable;

final class ClienteData implements Wireable
{
    use StaticCreateSelf;
    use ToArray;

    public function __construct(
        public array $clientable = [],
        public string $clientable_type = '',
        public ?int $clientable_id = null
    ) {
    }

    public function toLivewire()
    {
        return $this->toArray();
    }

    public static function fromLivewire($value)
    {
        return self::create($value);
    }
}
