<?php

namespace App\Livewire\Empresa;

use App\Classes\LivewireFormsComponent;
use App\Livewire\Forms\EmpresaForm;
use App\Models\Empresa;
use Exception;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\Computed;
use Livewire\Attributes\Locked;

final class EmpresaFormComponent extends LivewireFormsComponent
{
    use LivewireAlert;

    public EmpresaForm $form;

    #[Locked]
    public string $pageTitle = 'Crear Empresa';

    #[Locked]
    public ?string $uuid = null;

    public function render()
    {
        if ($this->uuid && empty($this->getErrorBag()->getMessages())) {
            $this->fillForm();
            $this->pageTitle = "Editar {$this->empresa->razon}";
        }

        return view('livewire.empresa.empresa-form-component');
    }

    public function mount(?string $uuid = null)
    {
        $this->uuid = $uuid;
    }

    #[Computed(persist: true)]
    public function empresa()
    {
        return Empresa::select(['id', 'razon', 'rif', 'direccion', 'telefono', 'telefono_secundario', 'whatsapp', 'telegram', 'correo'])->where('uuid', $this->uuid)->first();
    }

    public function save()
    {

        try {
            $this->form->save($this->empresa);
            $this->form->reset();
            $this->alert('success', 'Empresa creada satisfactoriamente.', [
                'timer' => 5000,
            ]);
            unset($this->empresa);
        } catch (Exception $e) {
            throw_if(env('APP_DEBUG'), $e);
            $this->alert('error', 'Error al crear a la empresa.', [
                'timer' => 5000,
            ]);
        }
    }

    protected function fillForm()
    {
        $this->form->fill([
            'razon' => $this->empresa->razon ?? '',
            'rif' => $this->empresa->rif ?? '',
            'direccion' => $this->empresa->direccion ?? '',
            'telefono' => $this->empresa->telefono ?? '',
            'telefono_secundario' => $this->empresa->telefono_secundario ?? '',
            'whatsapp' => $this->empresa->whatsapp ?? '',
            'telegram' => $this->empresa->telegram ?? '',
            'correo' => $this->empresa->correo ?? '',
        ]);
    }
}
