<?php

namespace App\Livewire\Forms;

use App\Models\Empresa;
use Illuminate\Validation\Rule;
use Livewire\Form;

final class EmpresaForm extends Form
{
    public string $razon = '';

    public string $rif = '';

    public string $direccion = '';

    public string $telefono = '';

    public string $telefono_secundario = '';

    public string $whatsapp = '';

    public string $telegram = '';

    public string $correo = '';

    public ?Empresa $empresa = null;

    public function rules()
    {
        $empresa = $this->empresa;

        // longitud de telefono no debve exceder 20 caracteres
        return [
            'razon' => ['required', Rule::unique('empresas')->ignore($empresa)],
            // 'rif' => ['required', Rule::unique('empresas')->ignore($empresa)],
            'telefono' => ['required', 'max:20'],
            'telefono_secundario' => ['max:20'],
            'whatsapp' => ['max:20'],
            'telegram' => ['max:20'],

            'correo' => ['email'],
        ];
    }

    public function messages()
    {
        return [
            'razon.required' => 'El campo es obligatorio.',
            'razon.unique' => 'Ya existe una empresa registrada con este nombre.',
            'rif.required' => 'El campo es obligatorio.',
            'rif.unique' => 'Ya existe una empresa registrada con este RIF.',
            'telefono.required' => 'El telefono es un campo obligatorio.',
            'correo.required' => "El campo es obligatorio.",
            'correo.email' => "Formato de correo electrónico invalido.",
            'telefono.max' => 'El telefono no debe exceder los 20 caracteres.',
            'telefono_secundario.max' => 'El telefono no debe exceder los 20 caracteres.',
            'whatsapp.max' => 'El telefono no debe exceder los 20 caracteres.',
            'telegram.max' => 'El telefono no debe exceder los 20 caracteres.',

        ];
    }

    public function save(?Empresa $empresa = null)
    {
        $this->empresa = $empresa;
        $this->validate();

        if ($empresa) {
            $this->update($empresa);
        } else {
            return $this->store();
        }
    }

    private function store()
    {

        return Empresa::create([
            'razon' => $this->razon,
            'rif' => $this->rif,
            'direccion' => $this->direccion,
            'telefono' => $this->telefono,
            'telefono_secundario' => $this->telefono_secundario,
            'whatsapp' => $this->whatsapp,
            'telegram' => $this->telegram,
            'correo' => $this->correo,
        ]);
    }

    private function update(Empresa $empresa)
    {

        $empresa->fill([
            'razon' => $this->razon,
            'rif' => $this->rif,
            'direccion' => $this->direccion ?? '',
            'telefono' => $this->telefono ?? '',
            'telefono_secundario' => $this->telefono_secundario ?? '',
            'whatsapp' => $this->whatsapp ?? '',
            'telegram' => $this->telegram ?? '',
            'correo' => $this->correo ?? '',
        ]);

        $empresa->save();
    }
}
