<?php

namespace App\Livewire\Forms;

use App\Models\Persona;
use Closure;
use Livewire\Form;

final class PersonaForm extends Form
{
    public string $nombres = '';

    public string $nacionalidad = 'V';

    public string $cedula = '';

    public string $direccion = '';

    public string $telefono = '';

    public string $telefono_secundario = '';

    public string $whatsapp = '';

    public string $telegram = '';

    public string $correo = '';

    public ?Persona $persona = null;

    // public  $nacionalidades = [
    //     ['value' => 'V', 'label' => 'V'],
    //     ['value' => 'E', 'label' => 'E'],
    //     // ... more options
    // ];





    public function rules()
    {

        // $nacionalidad = $this->nacionalidad;
        // $persona = $this->persona;

        return [
            'nombres' => ['required', 'max:255'],
            'cedula' => ['numeric'],
            // 'nacionalidad' => ['required', 'in:V,E,v,e'],
            // 'cedula' => [
            //     'required',
            //     "regex:/^\d{5,8}$/",
            //     function (string $attribute, mixed $value, Closure $fail) use ($nacionalidad, $persona) {
            //         $query = Persona::where('cedula', 'like', get_cedula($value, $nacionalidad))->first();
            //         if ($query && $persona != null && $persona->id != $query->id) {
            //             $fail('Número de cédula proporcionado ya está registrado');
            //         }
            //     },
            // ],
            'telefono' => ['required'],
            // 'correo' => ['required', 'email'],
            'telefono' => ['required', 'max:20'],
            'telefono_secundario' => ['max:20'],
            'whatsapp' => ['max:20'],
            'telegram' => ['max:20'],

            'correo' => ['email'],
        ];
    }

    public function messages()
    {

        return [
            'nombres.required' => "El campo es obligatorio.",
            'nacionalidad.required' => "El campo es obligatorio.",
            'nacionalidad.in' => "Nacionalidad proporcionada no es correcta.",
            'cedula.required' => "El campo es obligatorio.",
            'cedula.numeric' => 'Número de cédula debe ser un número.',
            // 'cedula.unique' => 'Número de cédula proporcionado ya está registrado.',
            'telefono.required' => "El campo es obligatorio.",
            'correo.required' => "El campo es obligatorio.",
            'correo.email' => "Formato de correo electrónico invalido.",
            'cedula.regex' => 'Número de cédula debe contener de 5 a 8 números.',
        ];
    }

    public function save(?Persona $persona = null)
    {
        $this->persona = $persona;
        $this->validate();

        if ($persona) {
            $this->update($persona);
        } else {
            return $this->store();
        }
    }

    private function store(): Persona
    {

        return Persona::create([
            'nombres' => $this->nombres,
            // 'cedula' => get_cedula($this->cedula, $this->nacionalidad) ?? null,
            'cedula' => $this->cedula ?? null,
            'direccion' => $this->direccion ?? null,
            'telefono' => $this->telefono,
            'telefono_secundario' => $this->telefono_secundario ?? null,
            'whatsapp' => $this->whatsapp ?? null,
            'telegram' => $this->telegram ?? null,
            'correo' => $this->correo ?? null,
        ]);
    }

    private function update(Persona $persona)
    {

        $persona->fill([
            'nombres' => $this->nombres,
            'cedula' => $this->cedula ?? null,
            'direccion' => $this->direccion ?? null,
            'telefono' => $this->telefono,
            'telefono_secundario' => $this->telefono_secundario ?? null,
            'whatsapp' => $this->whatsapp ?? null,
            'telegram' => $this->telegram ?? null,
            'correo' => $this->correo ?? null,
        ]);

        $persona->save();
    }
}
