<?php

namespace App\Livewire\Home;

use App\Models\Cobranza;
use Carbon\Carbon;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Component;
use Livewire\WithPagination;

class CuentasPorCobrarMensualActualComponent extends Component
{
    use LivewireAlert;
    use WithPagination;
    public string $search = '';
    public function updatingSearch()
    {
        $this->resetPage();
    }
    public function render()
    {
        $startOfMonth = Carbon::now()->format('Y-m-01');
        $endOfMonth = Carbon::now()->format('Y-m-t');

        $cobros = Cobranza::where('status', 'pendiente')
            ->where('fecha', '>', $startOfMonth)
            ->where('fecha', '<', Carbon::now())
            ->where('concepto', 'like', '%' . $this->search . '%')
            ->where('id',  'like', '%' . $this->search . '%')
            ->orderBy('fecha', 'desc')
            ->paginate(20);
        // $planes = Plan::search($this->search)->paginate(15);

        if (session()->has('message')) $this->alert(session('type'), session('message'));

        return view('livewire.home.cuentas-por-cobrar-mensual-actual-component', compact('cobros'));
    }
}
