<?php

namespace App\Livewire\Mikrotik;

use App\Classes\LivewireFormsComponent;
use App\Livewire\Forms\MikrotikForm;
use App\Models\Mikrotik;
use App\Models\ModeloMikrotik;
use App\Models\ProtocoloMikrotik;
use Exception;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\Computed;
use Livewire\Attributes\Locked;

final class MikrotikFormComponent extends LivewireFormsComponent
{
    use LivewireAlert;

    public MikrotikForm $form;

    #[Locked]
    public string $pageTitle = 'Registrar Mikrotik';

    #[Locked]
    public ?string $uuid = null;

    public function render()
    {
        if ($this->uuid && empty($this->getErrorBag()->getMessages())) {
            $this->fillForm();

            foreach ($this->mikrotik->protocolos as $protocolo) {
                $this->form->protocolos[$protocolo->protocolo] = $protocolo->pivot->puerto;
            }

            $this->pageTitle = "Editar {$this->mikrotik->nombre}";
        }

        $modelos_mikrotiks = ModeloMikrotik::all(['uuid', 'nombre']);
        $protocolos = ProtocoloMikrotik::all(['protocolo', 'puerto']);

        $data = [
            'modelos_mikrotiks' => $modelos_mikrotiks,
            'protocolos' => $protocolos,
        ];

        return view('livewire.mikrotik.mikrotik-form-component', $data);
    }

    public function mount(?string $uuid = null)
    {
        $protocolos = ProtocoloMikrotik::all(['protocolo', 'puerto']);
        $this->uuid = $uuid;

        foreach ($protocolos as $protocolo) {
            $this->form->protocolos[$protocolo->protocolo] = $protocolo->puerto;
        }
    }

    #[Computed(persist: true)]
    public function mikrotik()
    {
        return Mikrotik::with('protocolos')->select(['id', 'nombre', 'ip', 'serial', 'identify', 'modelo_mikrotik_id', 'vpn_user', 'vpn_password', 'vpn_server', 'ethr_corte1', 'ethr_corte2', 'usuario', 'clave'])->where('uuid', $this->uuid)->first();
    }

    public function save()
    {
        $this->validate();
        try {
            if ($this->uuid) {
                $this->mikrotik->update($this->form->toArray());
                // $this->alert('success', 'Plan actualizado correctamente.');
                return redirect()->route('mikrotiks.index')->with(
                    [
                        'type' => 'success',
                        'message' => 'Mikrotik actualizado correctamente'
                    ]
                );
            } else {
                $this->form->save($this->mikrotik);
                return redirect()->route('mikrotiks.index')->with(
                    [
                        'type' => 'success',
                        'message' => 'Mikrotik creado correctamente'
                    ]
                );
            }

            // try {
            //     $this->form->save($this->plan);
            //     // $this->form->reset();
            //     return redirect()->route('planes.index')->with(
            //         [
            //             'type' => 'success',
            //             'message' => 'Plan actualizado correctamente'
            //         ]
            //     );
            // } catch (Exception $e) {
            //     throw_if(env('APP_DEBUG'), $e);
            //     $this->alert('error', 'Error al registrar el plan.', [
            //         'timer' => 5000,
            //     ]);
            // }
        } catch (Exception $e) {
            throw_if(env('APP_DEBUG'), $e);
            $this->alert('error', 'Ocurrió un error al guardar el plan.');
        }





        // try {
        //     $this->form->save($this->mikrotik);
        //     // $this->form->reset();
        //     // $this->alert('success', 'Mikrotik registrado satisfactoriamente.', [
        //     //     'timer' => 5000,
        //     // ]);
        //     return redirect()->route('mikrotiks.index')->with(
        //         [
        //             'type' => 'success',
        //             'message' => 'Mikrotik creado correctamente'
        //         ]
        //     );
        //     unset($this->mikrotik);
        // } catch (Exception $e) {
        //     throw_if(env('APP_DEBUG'), $e);
        //     $this->alert('error', 'Error al registrar el mikrotik.', [
        //         'timer' => 5000,
        //     ]);
        // }
    }

    protected function fillForm()
    {
        $this->form->fill([
            'nombre' => $this->mikrotik->nombre,
            'ip' => $this->mikrotik->ip,
            'serial' => $this->mikrotik->serial,
            'identify' => $this->mikrotik->identify,
            'vpnUser' => $this->mikrotik->vpn_user,
            'vpnPassword' => $this->mikrotik->vpn_password,
            'vpnServer' => $this->mikrotik->vpn_server,
            'ethrCorte1' => $this->mikrotik->ethr_corte1 ?? '',
            'ethrCorte2' => $this->mikrotik->ethr_corte2 ?? '',
            'usuario' => $this->mikrotik->usuario,
            'clave' => $this->mikrotik->clave,
            'modelo' => ModeloMikrotik::find($this->mikrotik->modelo_mikrotik_id)->uuid,
        ]);
    }
}
