<?php

namespace App\Livewire;

use Exception;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Support\Facades\DB;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;
use Livewire\Component;
use Livewire\WithPagination;
use Spatie\Permission\Models\Permission;

class PermisosComponent extends Component
{
    use LivewireAlert;
    use WithPagination;

    //============================================ Variables
    public string $name = '';
    public string $search = '';
    public string $permiso = '';
    public int $method = 1;

    //============================================ Modal
    public string $modalTitle = 'Agregar Permiso';
    public function cancel()
    {
        $this->reset('name');
        $this->setTitleAddPermissionModal();
    }
    public function setTitleAddPermissionModal()
    {
        $this->method = 1;
        $this->modalTitle = 'Agregar Permiso';
    }
    public function setTitleEditPermissionModal()
    {
        $this->method = 2;
        $this->modalTitle = "Editar permiso - ($this->name)";
    }


    //============================================Busqueda
    public function updatingSearch()
    {
        $this->resetPage();
    }
    //============================================ Component
    public function save()
    {
        if ($this->method == 1) {
            $this->store();
        } else {
            $this->update();
        }
    }
    //====================== Store / Crear Permiso
    private function store()
    {

        $this->validate(
            [
                'name' => 'required|unique:permissions',
            ]
        );


        try {
            if (!Permission::where('name', 'LIKE', '%' . str_replace(' ', '_', trim(strtolower($this->name))) . '%')->first()) {
                $permiso = Permission::create([
                    'name' => str_replace(' ', '_', trim(strtolower($this->name))),
                    'guard_name' => 'web'
                ]);
                $this->alert('success', 'Permiso creado satisfactoriamente.', [
                    'timer' => 5000,
                ]);
            } else {

                $this->alert('error', 'Error al crear el rol.');
            }

            $this->reset('name');
        } catch (Exception $e) {
            // if (isset($permiso)) {
            //     $permiso->forceDelete();
            // }
            throw_if(env('APP_DEBUG'), $e);
            $this->alert('error', 'Error al crear el rol.');
        }
    }
    //====================== Editar
    public function edit(int $id)
    {
        try {
            $permiso = Permission::where('id', $id)->firstOrFail();
            $this->fill([
                'permiso' => $id,
                'name' => $permiso->name,
            ]);
            $this->method = 2;
        } catch (ModelNotFoundException $e) {
            $this->alert('error', 'Permiso no encontrado');
        } catch (Exception $e) {
            throw_if(env('APP_DEBUG'), $e);
            $this->alert('error', 'Error al actualizar el Permiso');
        }
        $this->setTitleEditPermissionModal();
        $this->dispatch('show-modal');
    }
    private function update()
    {
        try {
            $permiso = Permission::where('id', $this->permiso)->firstOrFail();

            $this->validate(
                [
                    'name' => 'required|unique:permissions',
                ]
            );

            $permiso->fill([
                'name' =>  str_replace(' ', '_', trim(strtolower($this->name))),
            ]);

            $permiso->save();

            $this->alert('success', 'Permiso actualizado satisfactoriamente.', [
                'timer' => 5000,
            ]);
        } catch (ModelNotFoundException $e) {
            $this->alert('error', 'Permiso no encontrado');
        }
        $this->setTitleAddPermissionModal();
        $this->cancel();
        $this->dispatch('hide-modal');
    }
    //====================== Eliminar
    public function confirmDelete(int $id)
    {
        $this->permiso = $id;
        $this->alert('warning', '¿Estas seguro?', [
            'position' => 'center',
            'text' => '¡Si elimina  este permiso no podra restaurarlo!',
            'showConfirmButton' => true,
            'confirmButtonText' => '¡Eliminar!',
            'showCancelButton' => true,
            'cancelButtonText' => 'Cancelar',
            'toast' => false,
            'onConfirmed' => 'confirmedDelete',
            'onDeny' => 'deniedDelete',
            'timer' => null,
            'reverseButtons' => true,
            'confirmButtonColor' => '#3085d6',
            'cancelButtonColor' => '#d33',
        ]);
    }
    #[On('confirmedDelete')]
    public function confirmedDelete()
    {
        try {
            $permiso = Permission::findById($this->permiso);

            $hasUserAssigned = $permiso->users()->exists();
            $permission_name = $permiso->name;
            if (!$permiso) {
                $this->alert('error', 'Error al eliminar el permiso', [
                    'text' => 'Permiso no encontrado',

                ]);
            } else if (count($permiso->roles) > 0) {
                $this->alert('error', 'Error al eliminar el permiso', [
                    'text' => 'El permiso tiene algun rol asignado',
                ]);
            } else if ($hasUserAssigned) {
                $this->alert('error', 'Error al eliminar el permiso', [
                    'text' => 'El permiso tiene algun usuario asignado',
                ]);
            } else {
                DB::table('permissions')->where('id', $this->permiso)->delete();
                // $permiso->delete();
                $this->alert('success', 'Exito al eliminar el permiso', [
                    'text' => $permission_name,
                ]);
            }
        } catch (Exception $e) {
            throw_if(env('APP_DEBUG'), $e);
            $this->alert('error', 'Error al eliminar el permiso');
        }
    }


    //====================== Render
    public function render()
    {
        $permissions = Permission::paginate(20);
        // $planes = Plan::search($this->search)->paginate(15);

        if (session()->has('message')) $this->alert(session('type'), session('message'));

        return view('livewire.roles-permisos.permisos.permisos-component', compact('permissions'));
    }
}
