<?php

namespace App\Livewire\Plan;

use App\Classes\LivewireFormsComponent;
use App\Livewire\Forms\PlanForm;
use App\Models\Plan;
use App\Models\Proveedor;
use Exception;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\Computed;
use Livewire\Attributes\Locked;

final class PlanFormComponent extends LivewireFormsComponent
{
    use LivewireAlert;

    public PlanForm $form;

    #[Locked]
    public string $pageTitle = 'Registrar Plan';

    #[Locked]
    public ?string $uuid = null;



    public function mount(?string $uuid = null)
    {
        $this->uuid = $uuid;
    }
    public function render()
    {
        if ($this->uuid && empty($this->getErrorBag()->getMessages())) {
            $this->fillForm();

            $this->pageTitle = "Editar {$this->plan->nombre}";
        }

        $proveedores = Proveedor::with('empresa')->get();
        return view('livewire.plan.plan-form-component', compact('proveedores'));
    }

    #[Computed(persist: true)]
    public function plan()
    {
        return Plan::where('uuid', $this->uuid)->first();
    }

    public function save()
    {

        // $this->validate($this->form->rules());
        // validar el formulario
        // $this->validate();
        try {
            if ($this->uuid) {
                $this->plan->update($this->form->toArray());
                // $this->alert('success', 'Plan actualizado correctamente.');
                return redirect()->route('planes.index')->with(
                    [
                        'type' => 'success',
                        'message' => 'Plan actualizado correctamente'
                    ]
                );
            } else {
                Plan::create($this->form->toArray());
                return redirect()->route('planes.index')->with(
                    [
                        'type' => 'success',
                        'message' => 'Plan creado correctamente'
                    ]
                );
            }

            // try {
            //     $this->form->save($this->plan);
            //     // $this->form->reset();
            //     return redirect()->route('planes.index')->with(
            //         [
            //             'type' => 'success',
            //             'message' => 'Plan actualizado correctamente'
            //         ]
            //     );
            // } catch (Exception $e) {
            //     throw_if(env('APP_DEBUG'), $e);
            //     $this->alert('error', 'Error al registrar el plan.', [
            //         'timer' => 5000,
            //     ]);
            // }
        } catch (Exception $e) {
            throw_if(env('APP_DEBUG'), $e);
            $this->alert('error', 'Ocurrió un error al guardar el plan.');
        }
    }

    protected function fillForm()
    {
        $this->form->fill([
            'nombre' => $this->plan->nombre,
            'costo' => $this->plan->costo,
            'precio' => $this->plan->precio,
            'proveedor_id' => $this->plan->proveedor_id,
        ]);
    }
}
