<?php

namespace App\Livewire;

use App\Models\Plan;
use App\Models\Proveedor;
use Livewire\Component;

class ProveedorPlanSelect extends Component
{
    public $proveedor_id;
    public $planes; // Initialize $planes as an empty array

    public function mount()
    {
        // Load all plans initially (optional)
        $this->planes = [];
    }

    public function updatedProveedorId()
    {
        if ($this->proveedor_id) {
            $this->planes = Plan::where('proveedor_id', $this->proveedor_id)->get();
        } else {
            $this->planes = [];
        }
    }

    public function render()
    {
        $proveedores = Proveedor::all();
        $planes = $this->planes;
        // $planes = [];

        return view('livewire.proveedor-plan-select', compact('proveedores', 'planes'));
    }
}
