<?php

namespace App\Livewire\Socio;

use App\Livewire\Data\PersonaData;
use App\Livewire\Data\SocioData;
use App\Models\Persona;
use App\Models\Socio;
use Exception;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\Locked;
use Livewire\Attributes\On;
use Livewire\Component;
use Livewire\WithPagination;

final class SocioComponent extends Component
{
    use LivewireAlert;
    use WithPagination;

    public string $search = '';

    public string $persona = '';

    public string $modalTitle = '';

    #[Locked]
    // public SocioData $detailData;
    public  $detailData;

    public function render()
    {
        $search = $this->search;

        $socios = Socio::whereHas('persona', function ($query) use ($search) {
            $query->where('nombres', 'like', "%$search%")
                ->orWhere('cedula', 'like', "%$search%")
                ->orWhere('telefono', 'like', "%$search%")
                ->orWhere('correo', 'like', "%$search%");
        })
            // ->paginate(15);
            ->get();
        if (session()->has('message')) $this->alert(session('type'), session('message'));

        return view('livewire.socio.socio-component', ['socios' => $socios]);
    }

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public function detail(string $uuid)
    {
        try {
            $persona = Persona::where('uuid', $uuid)->firstOrFail();

            $this->fill([
                'modalTitle' => "Información $persona->nombres",
                'detailData' => $persona,
                // 'detailData' => new SocioData(PersonaData::create($persona->toArray())),
            ]);

            $this->dispatch('show-detail');
        } catch (ModelNotFoundException $e) {
            $this->alert('error', 'Socio no encontrado.', [
                'timer' => 5000,
            ]);
        } catch (Exception $e) {
            throw_if(env('APP_DEBUG'), $e);
            $this->alert('error', 'Error al mostrar el detalle del socio.', [
                'timer' => 5000,
            ]);
        }
    }

    public function confirmDelete(string $uuid)
    {
        $this->persona = $uuid;

        $this->alert('warning', '¿Estas seguro?', [
            'position' => 'center',
            'text' => '¡Si elimina a este socio no podra restaurarlo!',
            'showConfirmButton' => true,
            'confirmButtonText' => '¡Eliminar!',
            'showCancelButton' => true,
            'cancelButtonText' => 'Cancelar',
            'toast' => false,
            'onConfirmed' => 'confirmedDelete',
            'onDeny' => 'deniedDelete',
            'timer' => null,
            'reverseButtons' => true,
            'confirmButtonColor' => '#3085d6',
            'cancelButtonColor' => '#d33',
        ]);
    }

    public function getListeners()
    {
        return [
            'confirmedDelete',
            'deniedDelete',
        ];
    }

    #[On('confirmedDelete')]
    public function confirmedDelete()
    {
        try {
            $persona = Persona::with('socio')->where('uuid', $this->persona)->first();

            if ($persona->socio) {
                $persona->socio->delete();
                $this->alert(message: 'Socio eliminado con exito.');
                $this->search = '';
            }
        } catch (Exception $e) {
            throw_if(env('APP_DEBUG'), $e);
            $this->alert('error', 'Error al eliminar al socio.');
        }
    }

    #[On('deniedDelete')]
    public function deniedDelete()
    {
        $this->persona = '';
    }
}
