<?php

namespace App\Livewire\Vendedor;

use App\Classes\LivewireFormsComponent;
use App\Livewire\Forms\PersonaForm;
use App\Models\Persona;
use App\Models\Vendedor;
use Exception;
use Illuminate\Database\Eloquent\Collection;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\Computed;
use Livewire\Attributes\Locked;

final class VendedorFormComponent extends LivewireFormsComponent
{
    use LivewireAlert;

    public PersonaForm $form;

    #[Locked]
    public string $pageTitle = 'Crear Vendedor';

    public string $personaSearch = '';

    public Collection $personasResult;

    public ?string $uuid = '';

    #[Locked]
    public ?string $personaUUID = '';

    public function render()
    {
        if ($this->uuid && empty($this->getErrorBag()->getMessages())) {
            $this->fillForm();
            $this->pageTitle = "Editar {$this->persona->nombres}";
        }

        return view('livewire.vendedor.vendedor-form-component');
    }

    public function mount(?string $uuid = null)
    {
        $this->personasResult = Persona::doesntHave('vendedor')->take(100)->get(['cedula', 'nombres']);
        $this->uuid = $uuid;
        $this->personaUUID = $uuid;
    }

    #[Computed]
    public function persona()
    {
        return Persona::select(['id', 'nombres', 'cedula', 'direccion', 'telefono', 'telefono_secundario', 'whatsapp', 'telegram', 'correo'])->where('uuid', $this->personaUUID)->first();
    }

    public function updatingPersonaSearch(string $value)
    {
        $this->personasResult = Persona::doesntHave('vendedor')->where('nombres', 'like', "%$value%")->take(100)->get(['cedula', 'nombres']);
    }

    public function cargarPersona()
    {
        $persona = Persona::where('nombres', 'like', $this->personaSearch)->first();

        if ($persona) {
            $this->personaUUID = $persona->uuid;

            $this->form->fill([
                'nombres' => $persona->nombres,
                'nacionalidad' => $persona->nacionalidad ?? 'V',
                'cedula' => $persona->cedula ?? '',
                'direccion' => $persona->direccion,
                'telefono' => $persona->telefono,
                'telefono_secundario' => $persona->telefono_secundario,
                'whatsapp' => $persona->whatsapp,
                'telegram' => $persona->telegram,
                'correo' => $persona->correo,
            ]);

            $this->reset('personaSearch');
        }
    }

    public function save()
    {

        try {

            if ($this->personaUUID) {
                $persona = Persona::where('uuid', $this->personaUUID)->first();
                $this->form->save($persona);
            } else {
                $persona = $this->form->save();
            }

            if (Vendedor::where('persona_id', $persona->id)->first()) {
                // $this->alert('success', 'Vendedor actualizado satisfactoriamente.', [
                //     'timer' => 5000,
                // ]);
                return redirect()->route('vendedores.index')->with(
                    [
                        'type' => 'success',
                        'message' => 'Vendedor actualizado correctamente'
                    ]
                );
            } else {
                $persona->vendedor()->create();

                // $this->alert('success', 'Vendedor creado satisfactoriamente.', [
                //     'timer' => 5000,
                // ]);

                // $this->form->reset();
                $this->reset('personaUUID');
                return redirect()->route('vendedores.index')->with(
                    [
                        'type' => 'success',
                        'message' => 'Vendedor Creado correctamente'
                    ]
                );
            }
        } catch (Exception $e) {
            throw_if(env('APP_DEBUG'), $e);
            $this->alert('error', 'Error al crear/actualizar el vendedor.', [
                'timer' => 5000,
            ]);
        }
    }

    protected function fillForm()
    {
        $this->form->fill([
            'nombres' => $this->persona->nombres,
            'nacionalidad' => $this->persona->nacionalidad ?? 'V',
            'cedula' => $this->persona->cedula ?? '',
            'direccion' => $this->persona->direccion,
            'telefono' => $this->persona->telefono,
            'telefono_secundario' => $this->persona->telefono_secundario,
            'whatsapp' => $this->persona->whatsapp,
            'telegram' => $this->persona->telegram,
            'correo' => $this->persona->correo,
        ]);
    }
}
