<?php

namespace App\Models;

use App\Traits\GenerateUuid;
use App\Traits\RouteUuid;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphTo;

final class Cliente extends Model
{
    use GenerateUuid;
    use HasFactory;
    use RouteUuid;

    protected $with = ['clientable'];

    public function clientable(): MorphTo
    {
        return $this->morphTo();
    }
    public function empresa(): MorphTo
    {
        return $this->morphTo();
    }
    // relacion a remotas
    public function remotas()
    {
        return $this->hasMany(Remota::class);
    }
    public function remotasActivas()
    {
        return $this->remotas()->where('status', 'activo');
    }
    public function remotasActivasDelMesActual()
    {
        $inicioDelMes = now()->startOfMonth();
        $finDelMes = now()->endOfMonth();


        return $this->remotas()
            ->where('status', 'activo')
            ->whereHas('cobrosRemotas', function ($query) use ($inicioDelMes, $finDelMes) {
                $query->where('status', 'pendiente') // Asegúrate de que este sea el nombre correcto del campo
                    ->whereBetween('fecha', [$inicioDelMes, now()]); // Asegúrate de que este sea el nombre correcto del campo
            });
    }
    public function montoPendienteRemotasActivas()
    {

        return $this->remotasActivas()
            ->whereHas('cobrosRemotas', function ($query) {
                $query->where('status', 'pendiente'); // Filtra los cobros pendientes
            })
            ->with('cobrosRemotas') // Carga la relación de cobros
            ->get() // Obtiene las remotas activas
            ->sum(function ($remota) {
                // Suma los montos de los cobros pendientes para cada remota
                return $remota->cobrosRemotas->where('status', 'pendiente')->sum('monto');
            });
    }
    public function persona(): MorphTo
    {
        return $this->morphTo();
    }

    public function getClientName(): string
    {
        if ($this->clientable_type == 'App\Models\Empresa') {
            return (string) $this->clientable->razon;
        } else {
            return (string) $this->clientable->nombres;
        }
    }

    public function getTipoCliente(): string
    {
        if ($this->clientable_type == 'App\Models\Empresa') {
            return 'Empresa';
        } else {
            return 'Persona';
        }
    }
    public function getTipoNombre(): string
    {
        if ($this->clientable_type == 'App\Models\Empresa') {
            return 'Razon';
        } else {
            return 'Nombre';
        }
    }
    public function getTipoDocumento(): string
    {
        if ($this->clientable_type == 'App\Models\Empresa') {
            return 'RIF';
        } else {
            return 'Cedula';
        }
    }
    public function getDocumento()
    {
        if ($this->clientable_type == 'App\Models\Empresa') {
            return ($this->clientable->rif == '' ? 'N/R' : $this->clientable->rif) ?? 'N/R';
        } else {
            return ($this->clientable->cedula == '' ? 'N/R' : $this->clientable->cedula) ?? 'N/R';
        }
    }
    public function getDireccion()
    {
        if ($this->clientable_type == 'App\Models\Empresa') {
            return ($this->clientable->direccion == '' ? 'N/R' : $this->clientable->direccion) ?? 'N/R';
        } else {
            return ($this->clientable->direccion == '' ? 'N/R' : $this->clientable->direccion) ?? 'N/R';
        }
    }
    public function getTelefono()
    {
        if ($this->clientable_type == 'App\Models\Empresa') {
            return ($this->clientable->telefono == '' ? 'N/R' : $this->clientable->telefono) ?? 'N/R';
        } else {
            return ($this->clientable->telefono == '' ? 'N/R' : $this->clientable->telefono) ?? 'N/R';
        }
    }

    // telefono secundario
    public function getTelefonoSecundario()
    {
        if ($this->clientable_type == 'App\Models\Empresa') {
            return ($this->clientable->telefono_secundario == '' ? 'N/R' : $this->clientable->telefono_secundario) ?? 'N/R';
        } else {
            return ($this->clientable->telefono_secundario == '' ? 'N/R' : $this->clientable->telefono_secundario) ?? 'N/R';
        }
    }
    // telegram
    public function getTelegram()
    {
        if ($this->clientable_type == 'App\Models\Empresa') {
            return ($this->clientable->telegram == '' ? 'N/R' : $this->clientable->telegram) ?? 'N/R';
        } else {
            return ($this->clientable->telegram == '' ? 'N/R' : $this->clientable->telegram) ?? 'N/R';
        }
    }
    // correo
    public function getCorreo()
    {
        if ($this->clientable_type == 'App\Models\Empresa') {
            return ($this->clientable->correo == '' ? 'N/R' : $this->clientable->correo) ?? 'N/R';
        } else {
            return ($this->clientable->correo == '' ? 'N/R' : $this->clientable->correo) ?? 'N/R';
        }
    }




    public function getIdentity()
    {
        if ($this->clientable_type == 'App\Models\Empresa') {
            return $this->clientable->rif;
        } else {
            return $this->clientable->cedula;
        }
    }
    public function getWhatsapp()
    {
        if ($this->clientable_type == 'App\Models\Empresa') {
            return ($this->clientable->whatsapp == '' ? 'N/R' : $this->clientable->whatsapp) ?? 'N/R';
        } else {
            return ($this->clientable->whatsapp == '' ? 'N/R' : $this->clientable->whatsapp) ?? 'N/R';
        }
    }
}
