<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CobrosHistorial extends Model
{
    use HasFactory;

    protected $table = 'cobros_historial';

    protected $fillable = [
        'cliente_id',
        'concepto',
        'cobro_id',
        'remota_id',
        'monto',
        'fecha_pago',
        'numero_recibo',
        'observaciones',
        'payment_method_id',
        'utilidad',
    ];

    public function cliente()
    {
        return $this->belongsTo(Cliente::class);
    }

    public function cobro()
    {
        return $this->belongsTo(Cobranza::class);
    }

    public function remota()
    {
        return $this->belongsTo(Remota::class);
    }

    public function paymentMethod()
    {
        return $this->belongsTo(PaymentMethod::class, 'payment_method_id');
    }

    public function getVendedorAttribute()
    {
        return $this->cobro->remota->vendedor->persona->nombres;
    }

    public function getFechaPagoAttribute($value)
    {
        return date('d/m/Y', strtotime($value));
    }

    public function setFechaPagoAttribute($value)
    {
        $this->attributes['fecha_pago'] = date('Y-m-d', strtotime($value));
    }

    public function getMontoMoneyFormatAttribute($value)
    {
        return number_format($value, 2, '.', ',');
    }

    public function setMontoAttribute($value)
    {
        $this->attributes['monto'] = str_replace(',', '', $value);
    }

    public function getNombreMesAttribute()
    {
        return date('F', strtotime($this->fecha_pago));
    }
}
