<?php

namespace App\Models;

use App\Traits\GenerateUuid;
use App\Traits\RouteUuid;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\Relations\MorphOne;
use Illuminate\Database\Eloquent\SoftDeletes;
use Laravel\Scout\Searchable;

final class Empresa extends Model
{
    use GenerateUuid;
    use HasFactory;
    use RouteUuid;
    use Searchable;
    use SoftDeletes;

    protected $fillable = [
        'rif', 'razon', 'direccion', 'telefono', 'telefono_secundario', 'whatsapp', 'telegram', 'correo', 'uuid',
    ];

    public function cliente(): MorphOne
    {
        return $this->morphOne(Cliente::class, 'clientable');
    }

    public function proveedor(): HasOne
    {
        return $this->hasOne(Proveedor::class);
    }

    public function toSearchableArray()
    {
        return [
            'razon' => $this->nombre,
            'rif' => $this->rif,
            'telefono' => $this->telefono,
            'correo' => $this->correo,
        ];
    }
}
