<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class HistorialRecargas extends Model
{
    use HasFactory;
    protected $table = 'historial_de_recargas';


    protected $fillable = [
        'correo_de_cuenta',
        'fecha_de_recarga',
        'monto_de_recarga',
        'payment_method_id',

    ];


    public function paymentMethod()
    {
        return $this->belongsTo(PaymentMethod::class, 'payment_method_id');
    }
}
