<?php

namespace App\Models;

use App\Traits\GenerateUuid;
use App\Traits\RouteUuid;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use Laravel\Scout\Searchable;

final class Mikrotik extends Model
{
    use GenerateUuid;
    use HasFactory;
    use RouteUuid;
    use Searchable;
    use SoftDeletes;

    protected $fillable = ['nombre', 'ip', 'serial', 'identify', 'modelo_mikrotik_id', 'vpn_user', 'vpn_password', 'vpn_server', 'protocolo_mikrotik_id', 'ethr_corte1', 'ethr_corte2', 'usuario', 'clave', 'uuid'];

    public function modelo(): BelongsTo
    {
        return $this->belongsTo(ModeloMikrotik::class, 'modelo_mikrotik_id', 'id');
    }

    public function protocolos(): BelongsToMany
    {
        return $this->belongsToMany(ProtocoloMikrotik::class)->withPivot(['puerto']);
    }

    public function toSearchableArray()
    {
        return [
            'nombre' => $this->nombre,
            'serial' => $this->serial,
            'identify' => $this->identify,
        ];
    }
}
