<?php

namespace App\Models;

use App\Traits\HasPersona;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

final class Socio extends Model
{
    use HasFactory;
    use HasPersona;
    use SoftDeletes;

    protected $fillable = ['persona_id'];

    protected $with = ['persona'];

    public function persona(): BelongsTo
    {
        return $this->belongsTo(Persona::class);
    }
}
