<?php

namespace App\Models\TicketPlus;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PcValidacion extends Model
{
    use HasFactory;

    protected $connection = 'ticketplus';
    protected $table = 'pcvalidacion';

    protected $fillable = [
        'TxtHashkey',
        'Txt_brand',
        'TxtModel',
        'TxtModelMK',
        'TxtHardware',
        'TxtIdentity',
        'TxtSerialMK',
        'TxtIp',
        'IntIdCliente',
        'TxtDetalle',
        'DatFecha',
        'DatVen',
        'IntTLicencia',
        'VPN',
        'VPNVEN',
        'CLOUD',
        'IntDiasVenc',
        'IntStatus',
        'IntTrans',
        'IntPadre'
    ];

    /**
     * Obtiene los registros agrupados por TxtIdentity
     * Permite acceder a cada registro individual dentro de cada grupo
     *
     * @return \Illuminate\Support\Collection
     */
    public static function obtenerClientes()
    {
        return self::all()->groupBy('TxtIdentity');
    }

    /**
     * Obtiene los registros agrupados por TxtIdentity con información adicional
     * Incluye el conteo de registros por grupo y facilita el acceso a los elementos
     *
     * @return array
     */
    public static function obtenerClientesDetallado()
    {
        $registrosAgrupados = self::orderBy('TxtIdentity')->get()->groupBy('TxtIdentity');

        $resultado = [];

        foreach ($registrosAgrupados as $identity => $registros) {
            $resultado[$identity] = [
                'identity' => $identity,
                'total_registros' => $registros->count(),
                'registros' => $registros->toArray(),
                'primer_registro' => $registros->first(),
                'ultimo_registro' => $registros->last()
            ];
        }

        return $resultado;
    }

    // $usuariosA = DB::connection('ticketplus')->table('pcvalidacion')->get();
}
