<?php

namespace App\Models;

use App\Traits\HasPersona;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

final class Vendedor extends Model
{
    use HasFactory;
    use HasPersona;

    protected $table = 'vendedores';

    protected $fillable = ['persona_id'];

    protected $with = ['persona'];

    public function persona(): BelongsTo
    {
        return $this->belongsTo(Persona::class);
    }
    public function remotas()
    {
        return $this->hasMany(Remota::class);
    }
}
