<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Blade;
use Illuminate\Support\Str;

class BladeServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        Blade::directive('money', function ($expression) {
            // Lógica de la directiva
            return "<?php echo number_format($expression, 2, '.', ','); ?>";
        });
        Blade::directive('truncate', function ($expression) {
            // Parseamos la expresión para obtener el texto y la longitud
            // Eliminamos los paréntesis y espacios extra
            $params = explode(',', str_replace(['(', ')', ' '], '', $expression));

            // El primer parámetro será el texto
            $text = $params[0];

            // El segundo parámetro es la longitud. Si no se pasa, usamos 30 por defecto.
            $length = isset($params[1]) ? $params[1] : 30;

            // Usamos Str::limit() para truncar el texto
            return "<?php echo Str::limit($text, $length, '...'); ?>";
        });
    }
}
