<?php

namespace App\View\Components\Dashboard;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

abstract class DashboardCounterCard extends Component
{
    /**
     * Create a new component instance.
     */
    public function __construct(
        public readonly string $title,
        public readonly string $description,
        public readonly int $count,
        public readonly string $linkText,
        public readonly string $link
    ) {
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.dashboard.dashboard-counter-card');
    }
}
