<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Empresa>
 */
final class EmpresaFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'rif' => $this->faker->numerify($this->faker->randomElement(['V', 'E', 'P', 'G', 'J']) . '########-#'),
            'razon' => $this->faker->company(),
            // 'razon' => $this->faker->company() . ' ' . $this->faker->numberBetween(),
            'direccion' => $this->faker->address(),
            'telefono' => $this->faker->phoneNumber(),
            'telefono_secundario' => $this->faker->phoneNumber(),
            'whatsapp' => $this->faker->phoneNumber(),
            'telegram' => $this->faker->phoneNumber(),
            'correo' => $this->faker->safeEmail(),
            'uuid' => $this->faker->uuid(),
        ];
    }
}
