<?php

namespace Database\Factories;

use App\Models\ModeloMikrotik;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Mikrotik>
 */
final class MikrotikFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'nombre' => $this->faker->name(),
            'ip' => $this->faker->ipv4(),
            'serial' => $this->faker->numerify('######'),
            'identify' => $this->faker->name(),
            'modelo_mikrotik_id' => ModeloMikrotik::inRandomOrder()->value('id'),
            'vpn_user' => $this->faker->userName(),
            'vpn_password' => $this->faker->password(),
            'vpn_server' => $this->faker->ipv4(),
            'ethr_corte1' => $this->faker->date(),
            'ethr_corte2' => $this->faker->date(),
            'usuario' => $this->faker->userName(),
            'clave' => $this->faker->password(),
            'uuid' => $this->faker->uuid(),
        ];
    }
}
