<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('remotas', function (Blueprint $table) {
            $table->id();
            $table->string('equipo', 100);
            $table->string('serial', 100);
            $table->string('kit_serial')->nullable();
            $table->string('antena_serial')->nullable();
            $table->date('dia_corte');
            $table->date('dia_activacion');
            $table->date('fecha_cuenta')->nullable();
            $table->string('detalle', 300)->nullable();
            $table->ipAddress('ip_gestion')->nullable();
            $table->foreignId('cliente_id')->references('id')->on('clientes')->onUpdate('cascade')->onDelete('cascade');
            $table->foreignId('plan_id')->references('id')->on('planes')->onUpdate('cascade')->onDelete('cascade');
            // socio id que permita nulos
            $table->foreignId('socio_id')->nullable()->references('id')->on('socios')->onUpdate('cascade')->onDelete('restrict');
            $table->foreignId('vendedor_id')->references('id')->on('vendedores')->onUpdate('cascade')->onDelete('restrict');
            $table->foreignId('proveedor_id')->references('id')->on('proveedores')->onUpdate('cascade')->onDelete('cascade');
            $table->uuid();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('remotas');
    }
};
