<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('mikrotik_protocolo_mikrotik', function (Blueprint $table) {
            $table->id();
            $table->foreignId('protocolo_mikrotik_id')->references('id')->on('protocolos_mikrotiks')->onUpdate('cascade')->onDelete('cascade');
            $table->foreignId('mikrotik_id')->references('id')->on('mikrotiks')->onDelete('cascade')->onUpdate('cascade');
            $table->string('puerto', 6);
            $table->timestamps();
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('protocolos_mikrotics_mikrotics');
    }
};
