<?php

use App\Enums\TipoConfiguracion;
use Carbon\Carbon;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('configuraciones', function (Blueprint $table) {
            $table->id();
            $table->string('display_name')->unique();
            $table->string('clave')->unique();
            $table->string('valor')->nullable()->default('');
            $table->string('descripcion')->nullable();
            $table->enum('tipo', ['ARCHIVO', 'TEXTO', 'IMAGEN', 'NUMERO', 'BOOL']);
            $table->uuid();
            $table->timestamps();
        });

        DB::table('configuraciones')->insert([
            ['display_name' => 'Logo', 'clave' => 'logo', 'valor' => '', 'descripcion' => 'Logo del sistema', 'tipo' => TipoConfiguracion::IMAGEN, 'uuid' => str()->uuid()->toString(), 'created_at' => Carbon::now(), 'updated_at' => Carbon::now()],
            ['display_name' => 'Nombre Sistema', 'clave' => 'nombre_sistema', 'valor' => 'Panel Admin', 'descripcion' => 'Nombre del sistema', 'tipo' => TipoConfiguracion::TEXTO, 'uuid' => str()->uuid()->toString(), 'created_at' => Carbon::now(), 'updated_at' => Carbon::now()],
            ['display_name' => 'Versión Sistema', 'clave' => 'version_sistema', 'valor' => 'alfa', 'descripcion' => 'Versión actual del sistema', 'tipo' => TipoConfiguracion::TEXTO, 'uuid' => str()->uuid()->toString(), 'created_at' => Carbon::now(), 'updated_at' => Carbon::now()],
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('configuraciones');
    }
};
