<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('empresas', function (Blueprint $table) {
            // Eliminar empresas_rif_unique
            $table->dropUnique('empresas_rif_unique');
            // Eliminar empresas_razon_unique
            $table->dropUnique('empresas_razon_unique');

            //
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('empresas', function (Blueprint $table) {
            // Crear empresas_rif_unique
            // $table->unique('rif', 'empresas_rif_unique');
            // Crear empresas_razon_unique
            $table->unique('razon', 'empresas_razon_unique');

            //
        });
    }
};
