<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('cobros', function (Blueprint $table) {
            $table->dropForeign(['remota_id']);
            $table->dropColumn('remota_id');
            $table->dropForeign(['plan_id']);
            $table->dropColumn('plan_id');
            $table->dropColumn('utilidades');
            $table->dropColumn('fecha_cobro');
            $table->dropColumn('monto');
            $table->dropTimestamps();
            $table->foreignId('cliente_id')->constrained();
            $table->string('concepto');
            // remota_id
        });
        Schema::table('cobros', function (Blueprint $table) {
            $table->foreignId('remota_id')->nullable()->default(null)->constrained();
            $table->decimal('monto', 8, 2);
            $table->date('fecha')->nullable();
            $table->enum('status', ['pendiente', 'pagado'])->default('pendiente');
            $table->timestamps();
        });

        // fecha de pago

        // $table->timestamps();
    }

    public function down(): void
    {
        Schema::table('cobros', function (Blueprint $table) {
            $table->dropForeign(['cliente_id']);
            $table->dropColumn('cliente_id');
            $table->dropColumn('concepto');
            $table->dropForeign(['remota_id']);
            $table->dropColumn('remota_id');
            $table->dropColumn('monto');
            $table->dropColumn('fecha');
            $table->dropColumn('status');
            $table->dropTimestamps();
        });
    }
};
