<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('cobros', function (Blueprint $table) {
            $table->enum('status', ['pendiente', 'pagado', 'cancelado'])->default('pendiente')->change();
        });
        Schema::table('cobros_historial', function (Blueprint $table) {
            $table->text('observaciones')->nullable()->after('monto');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('cobros', function (Blueprint $table) {
            $table->enum('status', ['pendiente', 'pagado'])->default('pendiente')->change();
        });
        Schema::table('cobros_historial', function (Blueprint $table) {
            $table->dropColumn('observaciones');
        });
    }
};
