<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('remotas', function (Blueprint $table) {
            // al enum de status agregarle pausada por pago
            DB::statement("ALTER TABLE remotas MODIFY COLUMN status ENUM('activo', 'inactivo', 'pausada', 'pausada por pago', 'cancelada')");
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('remotas', function (Blueprint $table) {
            $table->enum('status', ['activa', 'pausada', 'cancelada'])->default('activa');
        });
    }
};
