<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('cobros_historial', function (Blueprint $table) {
            $table->unsignedBigInteger('payment_method_id')->after('cobro_id')->nullable(); // Agregar la columna
            $table->foreign('payment_method_id')
                ->references('id')->on('payment_methods')
                ->onDelete('set null');
        });
    }
    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('cobros_historial', function (Blueprint $table) {
            $table->dropForeign(['payment_method_id']);
            $table->dropColumn('payment_method_id'); // Eliminar la columna si se revierte la migración
        });
    }
};
