<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        try {
            DB::beginTransaction();

            // Obtener o crear el rol ADMIN
            $adminRole = Role::findByName('ADMIN');
            if (!$adminRole) {
                $adminRole = Role::create([
                    'name' => trim(strtoupper('ADMIN')),
                    'guard_name' => 'web'
                ]);
            }

            // Lista de permisos
            $permisos = [
                'cobranzas.cobros_mensualidades_futuras.index',
                'cobranzas.cobros_mensualidades_futuras.pagar',
                'cobranzas.cobros_mensualidades_futuras.exonerar',
                'cobranzas.cobros_mensualidades_futuras.whatsapp',
            ];

            foreach ($permisos as $permiso) {
                $permission = Permission::firstOrCreate(
                    ['name' => str_replace(' ', '_', trim(strtolower($permiso))), 'guard_name' => 'web']
                );

                // Asignar el permiso al rol ADMIN
                if (!$adminRole->hasPermissionTo($permission, 'web')) {
                    $adminRole->givePermissionTo($permission);
                }
            }



            DB::commit();
        } catch (\Throwable $th) {
            DB::rollBack(); // Asegúrate de hacer rollback en caso de error
            throw $th; // Lanzar la excepción después de hacer rollback
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
