<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('remotas', function (Blueprint $table) {
            $table->unsignedBigInteger('metodo_de_pago_id')->nullable()->default(1)->after('dia_activacion');

            $table->foreign('metodo_de_pago_id')->references('id')->on('payment_methods')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('remotas', function (Blueprint $table) {
            $table->dropForeign(['metodo_de_pago_id']);
            $table->dropColumn('metodo_de_pago_id');
        });
    }
};
