<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('historial_de_recargas', function (Blueprint $table) {
            // Eliminar la clave foránea si existe
            $table->dropForeign(['remota_id']); // Asegúrate de que el nombre sea correcto
            // Eliminar la columna
            $table->dropColumn('remota_id');

            // Agregar la nueva columna correo_de_cuenta
            $table->string('correo_de_cuenta')->after('id')->nullable(); // Cambia 'otra_columna' por el nombre de la columna después de la cual quieres agregarla
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('historial_de_recargas', function (Blueprint $table) {
            // Eliminar la columna correo_de_cuenta
            $table->dropColumn('correo_de_cuenta');

            // Restaurar la columna remota_id y su clave foránea
            $table->unsignedBigInteger('remota_id')->nullable();
            $table->foreign('remota_id')->references('id')->on('tabla_remota')->onDelete('cascade');
        });
    }
};
