<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('personas', function (Blueprint $table) {
            // Verificar si existe el índice único antes de eliminarlo
            $indexExists = collect(DB::select("SHOW INDEX FROM personas WHERE Key_name = 'personas_cedula_unique'"))->isNotEmpty();
            
            if ($indexExists) {
                // Eliminar la restricción única del campo cedula
                $table->dropUnique(['cedula']);
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('personas', function (Blueprint $table) {
            // Restaurar la restricción única en caso de rollback
            $table->string('cedula', 12)->unique()->change();
        });
    }
};
