<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('remotas', function (Blueprint $table) {
            // Agregar columna TxTIdentity después de la columna equipo
            $table->string('TxTIdentity', 150)->nullable()->after('equipo');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('remotas', function (Blueprint $table) {
            // Eliminar la columna TxTIdentity
            $table->dropColumn('TxTIdentity');
        });
    }
};
