<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('cobros_historial', function (Blueprint $table) {
            $table->string('numero_recibo', 50)->nullable()->after('monto')->comment('Número único del recibo generado');
            
            // Verificar si observaciones ya existe antes de agregarla
            if (!Schema::hasColumn('cobros_historial', 'observaciones')) {
                $table->text('observaciones')->nullable()->after('numero_recibo')->comment('Observaciones adicionales del pago');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('cobros_historial', function (Blueprint $table) {
            $table->dropColumn('numero_recibo');
            
            // Solo eliminar observaciones si fue agregada por esta migración
            if (Schema::hasColumn('cobros_historial', 'observaciones')) {
                $table->dropColumn('observaciones');
            }
        });
    }
};

