import './bootstrap';

import Swal from 'sweetalert2';
window.Swal = Swal;


import { Calendar } from '@fullcalendar/core';
import dayGridPlugin from '@fullcalendar/daygrid';
import interactionPlugin from '@fullcalendar/interaction';
import rrulePlugin from '@fullcalendar/rrule';


// Asegúrate de que el DOM esté completamente cargado
document.addEventListener('DOMContentLoaded', function () {
    var calendarEl = document.getElementById('calendar');

    var calendar = new Calendar(calendarEl, {
        plugins: [dayGridPlugin, interactionPlugin, rrulePlugin],
        initialView: 'dayGridMonth',
        events: '/api/getFechasDeCuentas', // La ruta de la API para obtener los eventos
        editable: true,
        droppable: true,
    });

    calendar.render();
});
