<x-guest-layout>

    @section('title')
    {{ __('Forgot Password') }}
    @endsection

    <div class="row align-items-center justify-content-center vh-100">
        <div class="card col-11 col-sm-8 col-md-6 col-lg-5 col-xl-4 col-xxl-3 py-6">

            <div class="d-flex justify-content-center mb-4">
                <img class="w-50" src="{{ get_logo_sistema() }}" alt="logo">
            </div>

            <!-- Title -->
            <h1 class="mb-2 text-center">
                {{ __("Forgot your password?") }}
            </h1>

            @if (session('status'))
            <div class="mb-4 text-success">
                {{ session('status') }}
            </div>
            @endif

            <x-validation-errors class="mb-4" />

            <!-- Form -->
            <form method="POST" action="{{ route('password.email') }}">
                @csrf
                <div class="row">
                    <div class="col-12">
                        <div class="mb-4">

                            <!-- Label -->
                            <label class="form-label">
                                {{ __("Email Address") }}
                            </label>

                            <!-- Input -->
                            <input type="email" class="form-control" id="email" name="email" :value="old('email')"
                                required autofocus autocomplete="email"
                                placeholder="{{ __('Enter your email address') }}">
                        </div>
                    </div>
                </div> <!-- / .row -->

                <div class="row align-items-center text-center">
                    <div class="col-12">

                        <!-- Button -->
                        <button type="submit" class="btn w-100 btn-primary mt-3 mb-2">{{ __("Email Password Reset Link")
                            }}</button>
                    </div>

                    <div class="col-12">

                        <!-- Link -->
                        <small class="mb-0 text-muted">Regresar al <a href="{{ route('login') }}"
                                class="fw-semibold">Login</a></small>
                    </div>
                </div> <!-- / .row -->
            </form>
        </div>
    </div> <!-- / .row -->

</x-guest-layout>